/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class GroupConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1052", false);
    private String m_reqGroup;
    private int m_refStatus = 2;
    private String m_refGid = "";

    public GroupConstraint(String quali, String fbaction, String val) {
        super("GROUP", quali, fbaction);
        this.m_reqGroup = val;
        this.setValid(false);
    }

    public GroupConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("GROUP");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        this.m_reqGroup = (String)ht.get("KeyData");
        this.setValid(true);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", Group : " + this.m_reqGroup + "]");
        return sb.toString();
    }

    @Override
    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("GROUP")) {
            throw new InvalidConstraintDataException("Constraint type does not match");
        }
        String quali = (String)ht.get("Qualifier");
        if (!quali.equals("EXIST") && !quali.equals("COMPARE")) {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
        if (!ht.containsKey("KeyData")) {
            throw new InvalidConstraintDataException("Missing KeyData");
        }
        int dsetlen = 4;
        if (ht.size() != dsetlen) {
            String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
            throw new InvalidConstraintDataException(errtxt);
        }
    }

    @Override
    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkGroup(nodeList, this.m_reqGroup, rset);
    }

    @Override
    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)("Checking compatibility:" + this));
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.checkGroup(nodeList, this.m_reqGroup, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        this.m_refStatus = refResult.getStatus();
        if (this.m_refStatus == 1) {
            this.m_refGid = (String)refResult.getResultInfoSet().elementAt(1);
        }
        Trace.out((String)("==== Reference data: " + refResult.getStatus() + ", gid[" + this.m_refGid + "]"));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            if (result.getStatus() == 3) {
                compStatus = this.m_refStatus == result.getStatus();
            } else {
                String gid = (String)result.getResultInfoSet().elementAt(1);
                Trace.out((String)("==== Refdata:" + refResult.getStatus() + "Nodedata: " + result.getStatus()));
                boolean bl = compStatus = refResult.getStatus() == result.getStatus() && this.m_refGid.equals(gid);
            }
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    @Override
    public void report(ResultSet rsltSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqGroup}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String grpStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                grpStatus = ReportUtil.EXIST;
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                grpStatus = ReportUtil.NOTEXIST;
                comment = ReportUtil.FAILED;
            } else {
                grpStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, grpStatus, comment);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqGroup}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqGroup}));
            ReportUtil.printErrorNodes(rsltSet);
        }
    }

    @Override
    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1006", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqGroup}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.GROUP_ID);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String gid;
            String extStatus;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                extStatus = ReportUtil.EXIST;
                gid = (String)result.getResultInfoSet().elementAt(1);
            } else if (result.getStatus() == 3) {
                if (result.getResultInfoSet().size() == 1) {
                    extStatus = ReportUtil.NOTEXIST;
                    gid = ReportUtil.UNKNOWN;
                } else {
                    extStatus = (String)result.getResultInfoSet().elementAt(0);
                    gid = (String)result.getResultInfoSet().elementAt(1);
                }
            } else {
                extStatus = ReportUtil.UNKNOWN;
                gid = ReportUtil.UNKNOWN;
            }
            ReportUtil.surewriteRecord(node, extStatus, gid);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqGroup}));
        }
    }

    @Override
    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1010", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqGroup, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.GROUP_AND_GID, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        String refText = this.m_refStatus == 1 ? this.m_reqGroup + "(" + this.m_refGid + ")" : ReportUtil.NOTEXIST;
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String gid;
            String comment;
            String cnText;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1 && this.m_refStatus == 3) {
                cnText = ReportUtil.NOTEXIST;
                comment = ReportUtil.MATCHED;
            } else if (this.m_refStatus == 1 && result.getStatus() == 1) {
                gid = (String)result.getResultInfoSet().elementAt(1);
                cnText = this.m_reqGroup + "(" + gid + ")";
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                if (result.getResultInfoSet().size() == 1) {
                    cnText = ReportUtil.NOTEXIST;
                } else {
                    gid = (String)result.getResultInfoSet().elementAt(1);
                    cnText = this.m_reqGroup + "(" + gid + ")";
                }
                comment = ReportUtil.MISMATCHED;
            } else {
                cnText = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, cnText, refText, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

